// MainForm̃{^{̂A상\bhȂ
#include "stdafx.h"
#include "MainForm.h"
#include "ConfigWikipediaDialog.h"

using namespace wpts;

/*  */
System::Void MainForm::MainForm_Load(System::Object^  sender, System::EventArgs^  e)
{
	// 
	cmnAP = gcnew MYAPP::Cmn();
	config = gcnew Config(Path::Combine(Application::StartupPath, Path::GetFileNameWithoutExtension(Application::ExecutablePath) + ".xml"));
	transAP = nullptr;
	textBoxLog->CheckForIllegalCrossThreadCalls = false;

	// c[`bv̐ݒ
	toolTip->SetToolTip(groupBoxTransfer, cmnAP->Resource->GetString("ToolTipMain_GroupBoxTransfer"));
	toolTip->SetToolTip(comboBoxSource, cmnAP->Resource->GetString("ToolTipMain_ComboBoxSource"));
	toolTip->SetToolTip(comboBoxTarget, cmnAP->Resource->GetString("ToolTipMain_ComboBoxTarget"));
	toolTip->SetToolTip(labelSource, cmnAP->Resource->GetString("ToolTipMain_LabelSource"));
	toolTip->SetToolTip(labelTarget, cmnAP->Resource->GetString("ToolTipMain_LabelTarget"));
	toolTip->SetToolTip(linkLabelSourceURL, cmnAP->Resource->GetString("ToolTipMain_LinkLabelSourceURL"));
	toolTip->SetToolTip(buttonConfig, cmnAP->Resource->GetString("ToolTipMain_ButtonConfig"));
	toolTip->SetToolTip(groupBoxSaveDirectory, cmnAP->Resource->GetString("ToolTipMain_GroupBoxSaveDirectory"));
	toolTip->SetToolTip(buttonSaveDirectory, cmnAP->Resource->GetString("ToolTipMain_ButtonSaveDirectory"));
	toolTip->SetToolTip(textBoxSaveDirectory, cmnAP->Resource->GetString("ToolTipMain_TextBoxSaveDirectory"));
	toolTip->SetToolTip(groupBoxRun, cmnAP->Resource->GetString("ToolTipMain_GroupBoxRun"));
	toolTip->SetToolTip(textBoxArticle, cmnAP->Resource->GetString("ToolTipMain_TextBoxArticle"));
	toolTip->SetToolTip(labelArticle, cmnAP->Resource->GetString("ToolTipMain_TextBoxArticle"));
	toolTip->SetToolTip(buttonRun, cmnAP->Resource->GetString("ToolTipMain_ButtonRun"));
	toolTip->SetToolTip(buttonStop, cmnAP->Resource->GetString("ToolTipMain_ButtonStop"));

	// R{{bNXݒ
	initialize();

	// ȌԂ𕜌
	textBoxSaveDirectory->Text = config->Client->SaveDirectory;
	comboBoxSource->SelectedText = config->Client->LastSelectedSource;
	comboBoxTarget->SelectedText = config->Client->LastSelectedTarget;
	// R{{bNXύX̏R[
	comboBoxSource_SelectedIndexChanged(sender, e);
	comboBoxTarget_SelectedIndexChanged(sender, e);
}

/* IAԂۑ */
System::Void MainForm::MainForm_FormClosed(System::Object^  sender, System::Windows::Forms::FormClosedEventArgs^  e)
{
	// グ̏ꍇAݒ肪XVĂ\̂ŁAݒēǂݍ
	config->Load();
	// ݂̍ƃtH_Aiݕۑ
	config->Client->SaveDirectory = textBoxSaveDirectory->Text;
	config->Client->LastSelectedSource = comboBoxSource->Text;
	config->Client->LastSelectedTarget = comboBoxTarget->Text;
	config->Save();
	// LbVtH_̌Ât@C̃NA
	try{
		DirectoryInfo ^dir = gcnew DirectoryInfo(Path::Combine(Path::GetTempPath(), Path::GetFileNameWithoutExtension(Application::ExecutablePath)));
		if(dir->Exists == true){
			array<FileInfo^> ^files = dir->GetFiles("*.xml");
			for each(FileInfo ^file in files){
				// 1TԈȏÕLbV͍폜
				if((DateTime::UtcNow - file->LastWriteTimeUtc) > TimeSpan(7, 0, 0, 0)){
					// ȂAĎ̃t@C
					try{
						file->Delete();
					}
					catch(Exception ^e){
						System::Diagnostics::Debug::WriteLine("MainForm::_FormClosed > LbV폜ɗO : " + e->Message);
					}
				}
			}
		}
	}
	catch(Exception ^e){
		System::Diagnostics::Debug::WriteLine("MainForm::_FormClosed > LbV폜ɗO : " + e->Message);
	}
}

/* |󌳃R{{bNX̕ύX */
System::Void MainForm::comboBoxSource_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e)
{
	// xɌꖼ\
	if(comboBoxSource->Text != ""){
		comboBoxSource->Text = comboBoxSource->Text->Trim()->ToLower();
		LanguageInformation ^lang = config->GetLanguage(comboBoxSource->Text);
		if(lang != nullptr){
			labelSource->Text = lang->GetName(System::Globalization::CultureInfo::CurrentCulture->TwoLetterISOLanguageName);
		}
		else{
			labelSource->Text = "";
		}
		// T[o[URL̕\
		if(config->Client->RunMode == Config::RunType::Wikipedia){
			WikipediaInformation ^svr;
			if(lang != nullptr){
				svr = dynamic_cast<WikipediaInformation^>(lang);
			}
			if(svr == nullptr){
				svr = gcnew WikipediaInformation(comboBoxSource->Text);
			}
			linkLabelSourceURL->Text = "http://" + svr->Server;
		}
		else{
			// ̊giHjp
			linkLabelSourceURL->Text = "http://";
		}
	}
	else{
		labelSource->Text = "";
		linkLabelSourceURL->Text = "http://";
	}
}

/* |R{{bNX̕ύX */
System::Void MainForm::comboBoxTarget_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e)
{
	// xɌꖼ\
	if(comboBoxTarget->Text != ""){
		comboBoxTarget->Text = comboBoxTarget->Text->Trim()->ToLower();
		LanguageInformation ^lang = config->GetLanguage(comboBoxTarget->Text);
		if(lang != nullptr){
			labelTarget->Text = lang->GetName(System::Globalization::CultureInfo::CurrentCulture->TwoLetterISOLanguageName);
		}
		else{
			labelTarget->Text = "";
		}
	}
	else{
		labelTarget->Text = "";
	}
}

/* |󌳃R{{bNX̃tH[JXr */
System::Void MainForm::comboBoxSource_Leave(System::Object^  sender, System::EventArgs^  e)
{
	// ړ͂ꂽꍇ̑΍AύX̏R[
	comboBoxSource_SelectedIndexChanged(sender, e);
}

/* |R{{bNX̃tH[JXr */
System::Void MainForm::comboBoxTarget_Leave(System::Object^  sender, System::EventArgs^  e)
{
	// ړ͂ꂽꍇ̑΍AύX̏R[
	comboBoxTarget_SelectedIndexChanged(sender, e);
}

/* o͐eLXg{bNX̃tH[JXr */
System::Void MainForm::textBoxSaveDirectory_Leave(System::Object^  sender, System::EventArgs^  e)
{
	// 󔒂폜
	textBoxSaveDirectory->Text = textBoxSaveDirectory->Text->Trim();
}

/* Nx̃NNbN */
System::Void MainForm::linkLabelSourceURL_LinkClicked(System::Object^  sender, System::Windows::Forms::LinkLabelLinkClickedEventArgs^  e)
{
	// NJ
	System::Diagnostics::Process::Start(linkLabelSourceURL->Text);
}

/* ݒ{^ */
System::Void MainForm::buttonConfig_Click(System::Object^  sender, System::EventArgs^  e)
{
	if(config->Client->RunMode == Config::RunType::Wikipedia){
		// ̐ݒʂJ
		ConfigWikipediaDialog ^dialog = gcnew ConfigWikipediaDialog();
		dialog->ShowDialog();
		// ʂɊ֌WȂAݒēǂݍ
		config->Load();
		// R{{bNXݒ
		String ^backupSourceSelected = comboBoxSource->SelectedText;
		String ^backupSourceTarget = comboBoxTarget->SelectedText;
		initialize();
		comboBoxSource->SelectedText = backupSourceSelected;
		comboBoxTarget->SelectedText = backupSourceTarget;
		// R{{bNXύX̏R[
		comboBoxSource_SelectedIndexChanged(sender, e);
		comboBoxTarget_SelectedIndexChanged(sender, e);
		// _CAO
		delete dialog;
	}
	else{
		// ̊giHjp
		cmnAP->InformationDialogResource("InformationMessage_DevelopingMethod", "WikipediaȊȌ");
	}
}

/* Qƃ{^ */
System::Void MainForm::buttonSaveDirectory_Click(System::Object^  sender, System::EventArgs^  e)
{
	// tH_͂ĂꍇAʒuɐݒ
	if(textBoxSaveDirectory->Text != ""){
		folderBrowserDialogSaveDirectory->SelectedPath = textBoxSaveDirectory->Text;
	}
	// tH_IʂI[v
	if(folderBrowserDialogSaveDirectory->ShowDialog() == System::Windows::Forms::DialogResult::OK){
		// tH_IꂽꍇAtH_ɑIꂽtH_ݒ
		textBoxSaveDirectory->Text = folderBrowserDialogSaveDirectory->SelectedPath;
	}
}

/* s{^ */
System::Void MainForm::buttonRun_Click(System::Object^  sender, System::EventArgs^  e)
{
	// ͒l`FbN
	if(textBoxArticle->Text->Trim() == ""){
		// lݒ肳ĂȂƂ͏
		return;
	}
	// Kvȏ񂪐ݒ肳ĂȂꍇ͏s
	if(Directory::Exists(textBoxSaveDirectory->Text) == false){
		cmnAP->WarningDialogResource("WarningMessage_UnuseSaveDirectory");
		buttonSaveDirectory->Focus();
		return;
	}
	else if(comboBoxSource->Text == ""){
		cmnAP->WarningDialogResource("WarningMessage_NotSelectedSource");
		comboBoxSource->Focus();
		return;
	}
	else if(comboBoxTarget->Text == ""){
		cmnAP->WarningDialogResource("WarningMessage_NotSelectedTarget");
		comboBoxTarget->Focus();
		return;
	}
	else if(comboBoxSource->Text == comboBoxTarget->Text){
		cmnAP->WarningDialogResource("WarningMessage_SourceEqualTarget");
		comboBoxTarget->Focus();
		return;
	}
	// ʂbN
	lock();
	// obNOEhs
	backgroundWorkerRun->RunWorkerAsync();
}

/* ~{^ */
System::Void MainForm::buttonStop_Click(System::Object^  sender, System::EventArgs^  e)
{
	// 𒆒f
	buttonStop->Enabled = false;
	if(backgroundWorkerRun->IsBusy == true){
		System::Diagnostics::Debug::WriteLine("MainForm::-Stop_Click > f");
		backgroundWorkerRun->CancelAsync();
		if(transAP != nullptr){
			transAP->CancellationPending = true;
		}
	}
}

/* s{^ obNOEhiXbhj */
System::Void MainForm::backgroundWorkerRun_DoWork(System::Object^  sender, System::ComponentModel::DoWorkEventArgs^  e)
{
	try{
		// |x̑O
		textBoxLog->Clear();
		logLastLength = 0;
		textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_Start"), MYAPP::Cmn::GetProductName(),
			DateTime::Now.ToString("F")));
		// ʂƃÔ߂̏o̓t@C쐬
		String ^fileName = "";
		String ^logName = "";
		makeFileName(fileName, logName, textBoxArticle->Text->Trim(), textBoxSaveDirectory->Text);

		// |xsAʂƃOt@Cɏo
		// ΏۂɉTranslatepIuWFNg𐶐
		if(config->Client->RunMode == Config::RunType::Wikipedia){
			WikipediaInformation ^source = dynamic_cast<WikipediaInformation^>(config->GetLanguage(comboBoxSource->Text));
			if(source == nullptr){
				source = gcnew WikipediaInformation(comboBoxSource->Text);
			}
			WikipediaInformation ^target = dynamic_cast<WikipediaInformation^>(config->GetLanguage(comboBoxTarget->Text));
			if(target == nullptr){
				target = gcnew WikipediaInformation(comboBoxTarget->Text);
			}
			transAP = gcnew TranslateWikipedia(source, target);
			static_cast<TranslateWikipedia^>(transAP)->UserAgent = config->Client->UserAgent;
			static_cast<TranslateWikipedia^>(transAP)->Referer = config->Client->Referer;
		}
		else{
			// ̊giHjp
			textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("InformationMessage_DevelopingMethod"), "WikipediaȊȌ"));
			cmnAP->InformationDialogResource("InformationMessage_DevelopingMethod", "WikipediaȊȌ");
			return;
		}
		transAP->LogUpdate += gcnew EventHandler(this, &MainForm::getLogUpdate);
		// sOɁA[U[璆~vĂ邩`FbN
		if(backgroundWorkerRun->CancellationPending == true){
			textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_Stop"), logName));
		}
		// |xs
		else{
			bool successFlag = transAP->Run(textBoxArticle->Text->Trim());
			// ɎԂ邽߁Ao̓t@CĊmF
			makeFileName(fileName, logName, textBoxArticle->Text->Trim(), textBoxSaveDirectory->Text);
			if(successFlag){
				// ʂo
				try{
					StreamWriter ^sw = gcnew StreamWriter(Path::Combine(textBoxSaveDirectory->Text, fileName));
					try{
						sw->Write(transAP->Text);
						textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_End"), fileName, logName));
					}
					finally{
						sw->Close();
					}
				}
				catch(Exception ^e){
					textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_ErrorFileSave"), Path::Combine(textBoxSaveDirectory->Text, fileName), e->Message));
					textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_Stop"), logName));
				}
			}
			else{
				textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_Stop"), logName));
			}
		}
		// Oo
		try{
			StreamWriter ^sw = gcnew StreamWriter(Path::Combine(textBoxSaveDirectory->Text, logName));
			try{
				sw->Write(textBoxLog->Text);
			}
			finally{
				sw->Close();
			}
		}
		catch(Exception ^e){
			textBoxLog->AppendText(String::Format(cmnAP->Resource->GetString("LogMessage_ErrorFileSave"), Path::Combine(textBoxSaveDirectory->Text, logName), e->Message));
		}
		// gpIuWFNgiԂvȂAÔ߁j
		delete transAP;
	}
	catch(Exception ^e){
		textBoxLog->AppendText("\r\n" + String::Format(cmnAP->Resource->GetString("ErrorMessage_DevelopmentMiss"), e->Message) + "\r\n");
	}
}

/* s{^ obNOEhiIj */
System::Void MainForm::backgroundWorkerRun_RunWorkerCompleted(System::Object^  sender, System::ComponentModel::RunWorkerCompletedEventArgs^  e)
{
	// ʂbN
	release();
}

/* ʏ */
Void MainForm::initialize(void)
{
	// R{{bNXݒ
	comboBoxSource->Items->Clear();
	comboBoxTarget->Items->Clear();
	for each(LanguageInformation ^lang in config->Languages){
		comboBoxSource->Items->Add(lang->Code);
		comboBoxTarget->Items->Add(lang->Code);
	}
	return;
}

/* ʂbNɈڍs */
void MainForm::lock(void)
{
	// e{^Ȃǂ͕sɕύX
	groupBoxTransfer->Enabled = false;
	groupBoxSaveDirectory->Enabled = false;
	textBoxArticle->Enabled = false;
	buttonRun->Enabled = false;
	// ~{^LɕύX
	buttonStop->Enabled = true;
}

/* ʂbN */
void MainForm::release(void)
{
	// ~{^͕sɕύX
	buttonStop->Enabled = false;
	// e{^ȂǂLɕύX
	groupBoxTransfer->Enabled = true;
	groupBoxSaveDirectory->Enabled = true;
	textBoxArticle->Enabled = true;
	buttonRun->Enabled = true;
}

//* nꂽt@CɎg镶ɕϊ */
bool MainForm::makeFileName(String ^%o_FileName, String ^%o_LogName, String ^i_Text, String ^i_Dir)
{
	// o͒l
	o_FileName = "";
	o_LogName = "";
	// o͐tH_ɑ݂Ȃt@Ci̊gqOj쐬
	// nꂽWikipedia̋LɃt@CɎgȂ܂܂ĂꍇA_ ɒu
	//   ܂At@CdĂꍇAxx[0].txt̂悤ɘAԂt
	String ^fileNameBase = MYAPP::Cmn::ReplaceInvalidFileNameChars(i_Text);
	String ^fileName = fileNameBase + ".txt";
	String ^logName = fileNameBase + ".log";
	bool successFlag = false;
	for(int i = 0 ; i < 100000 ; i++){
		// 100000܂Ŏċ󂫂ȂƂ͖͂AȂŌ̂㏑
		if(File::Exists(Path::Combine(i_Dir, fileName)) == false &&
		   File::Exists(Path::Combine(i_Dir, logName)) == false){
			successFlag = true;
			break;
		}
		fileName = fileNameBase + "[" + i + "]" + ".txt";
		logName = fileNameBase + "[" + i + "]" + ".log";
	}
	// ʐݒ
	o_FileName = fileName;
	o_LogName = logName;
	return successFlag;
}

/* |xNX̃Cxgp */
void MainForm::getLogUpdate(System::Object^  sender, System::EventArgs^  e)
{
	// Oȍ~ɒǉꂽOeLXg{bNXɏo
	int length = transAP->Log->Length;
	if(length > logLastLength){
		textBoxLog->AppendText(transAP->Log->Substring(logLastLength, length - logLastLength));
	}
	logLastLength = length;
}
